/*
 * Decompiled with CFR 0.152.
 */
package baguchan.revampedwolf.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WolfArmorItem
extends Item {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("d23be4cf-1b60-4daf-97e3-efe57b486b91");
    private final int armorValue;
    private final ResourceLocation texture;
    private final float toughness;
    protected final float knockbackResistance;
    protected final IArmorMaterial material;
    private final Multimap<Attribute, AttributeModifier> field_234656_m_;

    public WolfArmorItem(IArmorMaterial material, int armorValue, String tierArmor, Item.Properties properties) {
        this(material, armorValue, new ResourceLocation("revampedwolf", "textures/entity/wolf/armor/wolf_armor_" + tierArmor + ".png"), properties);
    }

    public WolfArmorItem(IArmorMaterial materialIn, int armorValue, ResourceLocation texture, Item.Properties properties) {
        super(properties);
        this.armorValue = armorValue;
        this.toughness = materialIn.func_200901_e();
        this.knockbackResistance = materialIn.func_230304_f_();
        this.texture = texture;
        this.material = materialIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID;
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, "Wolf Armor modifier", (double)this.armorValue, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(uuid, "Wolf Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
        if (this.knockbackResistance > 0.0f) {
            builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(uuid, "Wolf Armor knockback resistance", (double)this.knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        this.field_234656_m_ = builder.build();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.ARMOR || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.CHEST ? this.field_234656_m_ : super.func_111205_h(equipmentSlot);
    }

    public int func_77619_b() {
        return this.material.func_200900_a();
    }

    public IArmorMaterial getArmorMaterial() {
        return this.material;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.material.func_200898_c().test(repair) || super.func_82789_a(toRepair, repair);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getArmorTexture() {
        return this.texture;
    }

    public int getArmorValue() {
        return this.armorValue;
    }
}

